(function($) {
	
	"use strict";
	$(function() {  
		$('.btn-1')
		.on('mouseenter', function(e) {
				var parentOffset = $(this).offset(),
				relX = e.pageX - parentOffset.left,
				relY = e.pageY - parentOffset.top;
				$(this).find('span').css({top:relY, left:relX})
		})
		.on('mouseout', function(e) {
				var parentOffset = $(this).offset(),
				relX = e.pageX - parentOffset.left,
				relY = e.pageY - parentOffset.top;
			$(this).find('span').css({top:relY, left:relX})
		});
	});
	
	// Screen Width
	var screen_width = window.screen.width;

	// Active GSAP
	if (document.querySelector("#smooth__animate").classList.contains("smooth__scrool__animate")) {
		const smoother = ScrollSmoother.create({
			effects: screen_width < 1025 ? false : true,
			smooth: 1.35,
			ignoreMobileResize: true,
			normalizeScroll: false,
			smoothTouch: 0.1,
		});
	}

	function validation() {
		let form = document.getElementById('form')
		let email = document.getElementById('email').value
		let text = document.getElementById('text')
		let pattern = /^[^ ]+@[^ ]+\.[a-z]{2,3}$/
	  
		if (email.match(pattern)) {
		  form.classList.add('valid')
		  form.classList.remove('invalid')
		  text.innerHTML = "Your Email Address in valid"
		  text.style.color = '#00ff00'
		} else {
		  form.classList.remove('valid')
		  form.classList.add('invalid')
		  text.innerHTML = "Please Enter Valid Email Address"
		  text.style.color = '#ff0000'
		}
	  
		if (email == '') {
		  form.classList.remove('valid')
		  form.classList.remove('invalid')
		  text.innerHTML = ""
		  text.style.color = '#00ff00'
		}
	  }

	// simpleParallax activation

	var image = document.getElementsByClassName('imageParallax');
	new simpleParallax(image, {
		delay: .6,
		transition: 'cubic-bezier(0,0,0,1)'
	});


	var image = document.getElementsByClassName('imageParallax2');
	new simpleParallax(image, {
		delay: .6,
		transition: 'cubic-bezier(0,0,0,1)',
		orientation: 'right'
	});
	var image = document.getElementsByClassName('imageParallax3');
	new simpleParallax(image, {
		delay: .6,
		transition: 'cubic-bezier(0,0,0,1)',
		orientation: 'left'
	});

	var image = document.getElementsByClassName('imageParallax5');
	new simpleParallax(image, {
		delay: .6,
		transition: 'cubic-bezier(0,0,0,0.5)',
		orientation: 'right'
	});

	const swiper_thumbnail = new Swiper(".swiper_thumbnail", {
        slidesPerView: 1,
		loop: true,
    });
    const swiper = new Swiper('.swiper_main', {
        loop: true,
        speed: 1000,
		slidesPerView: 'auto',
		centeredSlides: true,
		a11y: true,
		keyboardControl: true,
		grabCursor: true,
        autoplay: {
            delay: 5000,
        },
        navigation: {
            nextEl: ".swiper-button-next",
            prevEl: ".swiper-button-prev",
        },
        thumbs: {
            swiper: swiper_thumbnail,
        },
    });

	if ($('.service_slider').length) {
		var twoItemCarousel = new Swiper('.service_slider', {
			preloadImages: false,
			loop: true,
			centeredSlides: false,
			resistance: true,
			resistanceRatio: 0.6,
			slidesPerView: 4,
			speed: 1000,
			spaceBetween: 30,
			parallax: false,
			effect: "slide",
			active: 'active',
			
			navigation: {
				nextEl: '.button_next',
				prevEl: '.button_prev',
			},
			pagination: {
				el: '.slider__pagination',
				clickable: true,
			},
			breakpoints: {
                1800: {
                  slidesPerView: 5,
                },
                1600: {
                  slidesPerView: 5,
                },
                1400: {
                  slidesPerView: 5,
                },
                1200: {
                  slidesPerView: 5,
                },
                991: {
                  slidesPerView: 4,
                }, 
                767: {
                  slidesPerView: 3,
                }, 
                400: {
                  slidesPerView: 1,
                }, 
                320: {
                  slidesPerView: 1,
                }, 
            }
		});
	}

	const swiftUpElements = document.querySelectorAll('.swift-up-text');

	swiftUpElements.forEach(elem => {

		const words = elem.textContent.split(' ');
		elem.innerHTML = '';

		words.forEach((el, index) => {
			words[index] = `<span><i>${words[index]}</i></span>`;
		});

		elem.innerHTML = words.join(' ');

		const children = document.querySelectorAll('span > i');
		children.forEach((node, index) => {
			node.style.animationDelay = `${index * .2}s`;
		});

	});

	if ($('.baner_slider').length) {
		var twoItemCarousel = new Swiper('.baner_slider', {
			preloadImages: false,
			loop: true,
			centeredSlides: false,
			resistance: true,
			resistanceRatio: 0.6,
			slidesPerView: 1,
			speed: 1000,
			animateOut: 'fadeOut',
    		animateIn: 'fadeIn',
			spaceBetween: 0,
			parallax: false,
			effect: "slide",
			active: 'active',
			
			navigation: {
				nextEl: '.button_next',
				prevEl: '.button_prev',
			},
			pagination: {
				el: '.slider__pagination',
				clickable: true,
			},
			breakpoints: {
                1200: {
                  slidesPerView: 1,
                },
                991: {
                  slidesPerView: 1,
                }, 
                767: {
                  slidesPerView: 1,
                }, 
                400: {
                  slidesPerView: 1,
                }, 
                320: {
                  slidesPerView: 1,
                }, 
            }
		});
	}


	
	

	//Hide Loading Box (Preloader)
	function handlePreloader() {
		if($('.loader-wrap').length){
			$('.loader-wrap').delay(300).fadeOut(200);
		}
	}

	if ($(".preloader-close").length) {
        $(".preloader-close").on("click", function(){
            $('.loader-wrap').delay(200).fadeOut(500);
        })
    }

	if ($('.side-navigation').length) {
        $('.side-nav-opener').on('click', function() {
            $('.side-navigation').addClass('open');
            return false;
        });
        $('.side-navigation-close-btn, .page-wrapper').on('click', function() {
            $('.side-navigation').removeClass('open');
        });
    };
	
	
	//Update Header Style and Scroll to Top
	function headerStyle() {
		if($('.main-header').length){
			var windowpos = $(window).scrollTop();
			var siteHeader = $('.main-header');
			var scrollLink = $('.scroll-top');
			if (windowpos >= 110) {
				siteHeader.addClass('fixed-header');
				scrollLink.addClass('open');
			} else {
				siteHeader.removeClass('fixed-header');
				scrollLink.removeClass('open');
			}
		}
	}
	
	headerStyle();


	//Submenu Dropdown Toggle
	if($('.main-header li.dropdown ul').length){
		$('.main-header .navigation li.dropdown').append('<div class="dropdown-btn"><span class="fas fa-angle-down"></span></div>');
		
	}

	//Mobile Nav Hide Show
	if($('.mobile-menu').length){
		
		$('.mobile-menu .menu-box').mCustomScrollbar();
		
		var mobileMenuContent = $('.main-header .menu-area .main-menu').html();
		$('.mobile-menu .menu-box .menu-outer').append(mobileMenuContent);
		$('.sticky-header .main-menu').append(mobileMenuContent);
		
		//Dropdown Button
		$('.mobile-menu li.dropdown .dropdown-btn').on('click', function() {
			$(this).toggleClass('open');
			$(this).prev('ul').slideToggle(500);
		});
		//Dropdown Button
		$('.mobile-menu li.dropdown .dropdown-btn').on('click', function() {
			$(this).prev('.megamenu').slideToggle(900);
		});
		//Menu Toggle Btn
		$('.mobile-nav-toggler').on('click', function() {
			$('body').addClass('mobile-menu-visible');
		});

		//Menu Toggle Btn
		$('.mobile-menu .menu-backdrop,.mobile-menu .close-btn').on('click', function() {
			$('body').removeClass('mobile-menu-visible');
		});
	}

	function dynamicCurrentMenuClass(selector) {
        let FileName = window.location.href.split('/').reverse()[0];

        selector.find('li').each(function () {
            let anchor = $(this).find('a');
            if ($(anchor).attr('href') == FileName) {
                $(this).addClass('current');
            }
        });
        // if any li has .current elmnt add class
        selector.children('li').each(function () {
            if ($(this).find('.current').length) {
                $(this).addClass('current');
            }
        });
        // if no file name return 
        if ('' == FileName) {
            selector.find('li').eq(0).addClass('current');
        }
    }

    // dynamic current class        
    let mainNavUL = $('.main-menu').find('.navigation');
    dynamicCurrentMenuClass(mainNavUL);
	
	// Scroll to a Specific Div
	if($('.scroll-to-target').length){
		$(".scroll-to-target").on('click', function() {
			var target = $(this).attr('data-target');
		   // animate
		   $('html, body').animate({
			   scrollTop: $(target).offset().top
			 }, 1000);
	
		});
	}

	//Search Popup
	if($('#search-popup').length){
		//Show Popup
		$('.search-toggler').on('click', function() {
			$('#search-popup').addClass('popup-visible');
		});
		$(document).keydown(function(e){
			if(e.keyCode === 27) {
				$('#search-popup').removeClass('popup-visible');
			}
		});
		//Hide Popup
		$('.close-search,.search-popup .overlay-layer').on('click', function() {
			$('#search-popup').removeClass('popup-visible');
		});
	}




	// Elements Animation
	if($('.wow').length){
		var wow = new WOW({
		mobile:       false
		});
		wow.init();
	}

	//Fact Counter + Text Count
	if($('.count-box').length){
		$('.count-box').appear(function(){
	
			var $t = $(this),
				n = $t.find(".count-text").attr("data-stop"),
				r = parseInt($t.find(".count-text").attr("data-speed"), 10);
				
			if (!$t.hasClass("counted")) {
				$t.addClass("counted");
				$({
					countNum: $t.find(".count-text").text()
				}).animate({
					countNum: n
				}, {
					duration: r,
					easing: "linear",
					step: function() {
						$t.find(".count-text").text(Math.floor(this.countNum));
					},
					complete: function() {
						$t.find(".count-text").text(this.countNum);
					}
				});
			}
			
		},{accY: 0});
	}


	//LightBox / Fancybox
	if($('.lightbox-image').length) {
		$('.lightbox-image').fancybox({
			openEffect  : 'fade',
			closeEffect : 'fade',
			helpers : {
				media : {}
			}
		});
	}



	// Date picker
	function datepicker () {
	    if ($('#datepicker').length) {
	        $('#datepicker').datepicker();
	    };
	}
	// Time picker
	function timepicker () {
	    if ($('input[name="time"]').length) {
	        $('input[name="time"]').ptTimeSelect();
	    }
	}
	
	//FAQ Box
	jQuery(document).ready(function(){
		jQuery('.titleWrapper').click(function(){
			var toggle = jQuery(this).next('div#descwrapper');
			jQuery(toggle).slideToggle("slow");
		});
		jQuery('.inactive').click(function(){
			jQuery(this).toggleClass('inactive active');
		});
	});



	//Timer Countdown
    if($('.timer').length){
		$(function(){
			 $('[data-countdown]').each(function() {
			var $this = $(this), finalDate = $(this).data('countdown');
			$this.countdown(finalDate, function(event) {
			  $this.html(event.strftime('%D days %H:%M:%S'));
			});
		  });
		 });
 
		$('.cs-countdown').countdown('').on('update.countdown', function(event) {
		   var $this = $(this).html(event.strftime('<div class="count-col"><span>%D</span><p>Days</p></div> <div class="count-col"><span>%H</span><p>Hours</p></div> <div class="count-col"><span>%M</span><p>Minutes</p></div> <div class="count-col"><span>%S</span><p>Seconds</p></div>'));
		 });
	 }

	//Accordion Active

	if ($('.accordion-box-style1').length) {
		$(".accordion-box-style1").on('click', '.accord-btn', function () {

			if ($(this).hasClass('active') !== true) {
				$('.accordion .accord-btn').removeClass('active');
			}
			if ($(this).next('.accord-content').is(':visible')) {
				$(this).removeClass('active');
				$(this).next('.accord-content').slideUp(500);
			} else {
				$(this).addClass('active');
				$('.accordion .accord-content').slideUp(500);
				$(this).next('.accord-content').slideDown(500);
			}
		});
	}
	  

	
	// testimonial-wrap
	if ($('.testimonial-wrap').length) {
        $('.testimonial-wrap').owlCarousel({
            loop:true,
			margin:0,
			nav:true,
    		active: true,
			smartSpeed: 1000,
			autoplay: 6000,
            navText: [ '<span class="icon-59"></span>', '<span class="icon-60"></span>' ],
            responsive:{
                0:{
                    items:1
                },
                600:{
                    items:1
                },
                800:{
                    items:1
                },
                1024:{
                    items:1
                }
            }
        });
    }

	// team-wrap
	if ($('.team-wrap').length) {
        $('.team-wrap').owlCarousel({
            loop:true,
			margin:20,
			nav:true,
    		active: true,
			smartSpeed: 1000,
			autoplay: 6000,
            navText: [ '<span class="icon-59"></span>', '<span class="icon-60"></span>' ],
            responsive:{
                0:{
                    items:1
                },
                600:{
                    items:1
                },
                800:{
                    items:2
                },
                1024:{
                    items:3
                }
            }
        });
    }

	// instragram-wrap
	if ($('.instragram-wrap').length) {
        $('.instragram-wrap').owlCarousel({
            loop:true,
			nav:true,
    		active: true,
			smartSpeed: 1000,
			autoplay: 6000,
            navText: [ '<span class="icon-59"></span>', '<span class="icon-60"></span>' ],
            responsive:{
                0:{
                    items:2
                },
                600:{
                    items:5
                },
                800:{
                    items:7
                },
                1024:{
                    items:8
                }
            }
        });
    }

	var brandSlider = $('.blog-carousel');
	brandSlider.owlCarousel({
		loop:true,
		margin:30,
		nav:true,
		active: true,
		center:true,
		smartSpeed: 1000,
		navText: [ '<span class="icon-59"></span>', '<span class="icon-60"></span>' ],
		responsive: {
			0: {
				items: 1
			},
			340: {
				items: 1
			},
			480: {
				items: 2
			},
			768: {
				items: 3
			},
			991: {
				items: 3
			},
			1200: {
				items: 3
			}
		}
	})
	function brandSliderClasses() {
		brandSlider.each(function() {
			var total = $(this).find('.owl-item.active').length;
			$(this).find('.owl-item').removeClass('firstactiveitem');
			$(this).find('.owl-item').removeClass('lastactiveitem');
			$(this).find('.owl-item.active').each(function(index) {
				if (index === 0) {
					$(this).addClass('firstactiveitem')
				}
				if (index === total - 1 && total > 1) {
					$(this).addClass('lastactiveitem')
				}
			})
		})
	}
	brandSliderClasses();
	brandSlider.on('translated.owl.carousel', function(event) {
		brandSliderClasses()
	}); 

	

		// Banner Style Two
		$(document).ready(function() {

			var sync1 = $("#sync1");
			var sync2 = $("#sync2");
			var slidesPerPage = 3; //globaly define number of elements per page
			var syncedSecondary = true;
		
			sync1.owlCarousel({
				items: 1,
				nav: true,
				autoplay: 6000, 
				dots: true,
				loop: true,
				animateOut: 'fadeOut',
				animateIn: 'fadeIn',
				active: true,
				smartSpeed: 1000,
				responsiveRefreshRate: 200,
				navText: [ '<span class="icon-59"></span>', '<span class="icon-60"></span>' ],
			}).on('changed.owl.carousel', syncPosition);
		
			sync2
				.on('initialized.owl.carousel', function() {
					sync2.find(".owl-item").eq(0).addClass("current");
				})
				.owlCarousel({
					items: slidesPerPage,
					dots: true,
					nav: true,
					smartSpeed: 200,
					slideSpeed: 500,
					slideBy: slidesPerPage, //alternatively you can slide by 1, this way the active slide will stick to the first item in the second carousel
					responsiveRefreshRate: 100
				}).on('changed.owl.carousel', syncPosition2);
		
			function syncPosition(el) {
				//if you set loop to false, you have to restore this next line
				//var current = el.item.index;
		
				//if you disable loop you have to comment this block
				var count = el.item.count - 1;
				var current = Math.round(el.item.index - (el.item.count / 2) - .5);
		
				if (current < 0) {
					current = count;
				}
				if (current > count) {
					current = 0;
				}
		
				//end block
		
				sync2
					.find(".owl-item")
					.removeClass("current")
					.eq(current)
					.addClass("current");
				var onscreen = sync2.find('.owl-item.active').length - 1;
				var start = sync2.find('.owl-item.active').first().index();
				var end = sync2.find('.owl-item.active').last().index();
		
				if (current > end) {
					sync2.data('owl.carousel').to(current, 100, true);
				}
				if (current < start) {
					sync2.data('owl.carousel').to(current - onscreen, 100, true);
				}
			}
		
			function syncPosition2(el) {
				if (syncedSecondary) {
					var number = el.item.index;
					sync1.data('owl.carousel').to(number, 100, true);
				}
			}
		
			sync2.on("click", ".owl-item", function(e) {
				e.preventDefault();
				var number = $(this).index();
				sync1.data('owl.carousel').to(number, 300, true);
			});
		});
		// End Banner Style Two
	
	//Tabs Box
	if($('.tabs-box').length){
		$('.tabs-box .tab-buttons .tab-btn').hover( function(e) {
			e.preventDefault();
			var target = $($(this).attr('data-tab'));
			
			if ($(target).is(':visible')){
				return false;
			}else{
				target.parents('.tabs-box').find('.tab-buttons').find('.tab-btn').removeClass('active-btn');
				$(this).addClass('active-btn');
				target.parents('.tabs-box').find('.tabs-content').find('.tab').fadeOut(0);
				target.parents('.tabs-box').find('.tabs-content').find('.tab').removeClass('active-tab');
				$(target).fadeIn(100);
				$(target).addClass('active-tab');
			}
		});
	}

		//Tabs Box Two
		if($('.tabs-box-two').length){
			$('.tabs-box-two .tab-buttons .tab-btn-two').on('click', function(e) {
				e.preventDefault();
				var target = $($(this).attr('data-tab'));
				
				if ($(target).is(':visible')){
					return false;
				}else{
					target.parents('.tabs-box-two').find('.tab-buttons').find('.tab-btn-two').removeClass('active-btn');
					$(this).addClass('active-btn');
					target.parents('.tabs-box-two').find('.tabs-content-two').find('.tab-two').fadeOut(0);
					target.parents('.tabs-box-two').find('.tabs-content-two').find('.tab-two').removeClass('active-tab');
					$(target).fadeIn(100);
					$(target).addClass('active-tab');
				}
			});
		}

	$(document).ready(function() {

		$('a.btn-gallery').on('click', function(event) {
			event.preventDefault();
			
			var gallery = $(this).attr('href');
		
			$(gallery).magnificPopup({
		  delegate: 'a',
				type:'image',
				gallery: {
					enabled: true
				}
			}).magnificPopup('open');
		});
		
	});
	


	//Parallax Scene for Icons
	if($('.parallax-scene-1').length){
		var scene = $('.parallax-scene-1').get(0);
		var parallaxInstance = new Parallax(scene);
	}
	if($('.parallax-scene-2').length){
		var scene = $('.parallax-scene-2').get(0);
		var parallaxInstance = new Parallax(scene);
	}
	if($('.parallax-scene-3').length){
		var scene = $('.parallax-scene-3').get(0);
		var parallaxInstance = new Parallax(scene);
	}
	if($('.parallax-scene-4').length){
		var scene = $('.parallax-scene-4').get(0);
		var parallaxInstance = new Parallax(scene);
	}
	if($('.parallax-scene-5').length){
		var scene = $('.parallax-scene-5').get(0);
		var parallaxInstance = new Parallax(scene);
	}
	if($('.parallax-scene-6').length){
		var scene = $('.parallax-scene-6').get(0);
		var parallaxInstance = new Parallax(scene);
	}
	if($('.parallax-scene-7').length){
		var scene = $('.parallax-scene-7').get(0);
		var parallaxInstance = new Parallax(scene);
	}

	//Product Tabs
	if($('.project-tab').length){
		$('.project-tab .project-tab-btns .p-tab-btn').on('click', function(e) {
			e.preventDefault();
			var target = $($(this).attr('data-tab'));
			
			if ($(target).hasClass('actve-tab')){
				return false;
			}else{
				$('.project-tab .project-tab-btns .p-tab-btn').removeClass('active-btn');
				$(this).addClass('active-btn');
				$('.project-tab .p-tabs-content .p-tab').removeClass('active-tab');
				$(target).addClass('active-tab');
			}
		});
	}


	//Add One Page nav
	if($('.scroll-nav').length) {
		$('.scroll-nav').onePageNav();
	}


	//Sortable Masonary with Filters
	function enableMasonry() {
		if($('.sortable-masonry').length){
	
			var winDow = $(window);
			// Needed variables
			var $container=$('.sortable-masonry .items-container');
			var $filter=$('.filter-btns');
	
			$container.isotope({
				filter:'*',
				 masonry: {
					columnWidth : '.masonry-item.small-column'
				 },
				animationOptions:{
					duration:500,
					easing:'linear'
				}
			});
			
	
			// Isotope Filter 
			$filter.find('li').on('click', function(){
				var selector = $(this).attr('data-filter');
	
				try {
					$container.isotope({ 
						filter	: selector,
						animationOptions: {
							duration: 500,
							easing	: 'linear',
							queue	: false
						}
					});
				} catch(err) {
	
				}
				return false;
			});
	
	
			winDow.on('resize', function(){
				var selector = $filter.find('li.active').attr('data-filter');

				$container.isotope({ 
					filter	: selector,
					animationOptions: {
						duration: 500,
						easing	: 'linear',
						queue	: false
					}
				});
			});
	
	
			var filterItemA	= $('.filter-btns li');
	
			filterItemA.on('click', function(){
				var $this = $(this);
				if ( !$this.hasClass('active')) {
					filterItemA.removeClass('active');
					$this.addClass('active');
				}
			});
		}
	}
	
	enableMasonry();


	//Jquery Spinner / Quantity Spinner
	if($('.quantity-spinner').length){
		$("input.quantity-spinner").TouchSpin({
		  verticalbuttons: true
		});
	}

	$("#slider").on("input change", (e)=>{
		const sliderPos = e.target.value;
		// Update the width of the foreground image
		$('.foreground-img').css('width', `${sliderPos}%`)
		// Update the position of the slider button
		$('.slider-button').css('left', `calc(${sliderPos}% - 33px)`)
	  });

	/*-- Heading Animation --*/
    let sc_animation1 = gsap.utils.toArray(".sc-animation1");
    let homeStratup = gsap.timeline();
    let sc_animation2 = document.querySelector(".sc-animation2");
    let sc_animation3 = document.querySelector(".sc-animation3");

    let sc_animation4 = document.querySelector(".sc-animation4");
    let sc_animation5 = document.querySelector(".sc-animation5");
    let sc_animation6 = document.querySelector(".sc-animation6");

    gsap.set(sc_animation4, {
        opacity: 0,
        y: 50,
    });
    gsap.set(sc_animation5, {
        opacity: 0,
        y: 50,
    });
    gsap.set(sc_animation6, {
        opacity: 0,
        y: 50,
    });
    let sc_animation2_split = new SplitText(sc_animation2, { type: "chars" });
    let sc_animation3_split = new SplitText(sc_animation3, { type: "chars words" });
    homeStratup.from(sc_animation2_split.chars, { duration: 1, x: 70, autoAlpha: 0, stagger: 0.1 });
    homeStratup.from(sc_animation3_split.words, { duration: 1, x: 50, autoAlpha: 0, stagger: 0.05 }, "-=1");
    homeStratup.to(sc_animation4, { opacity: 1, y: 0, duration: 1, ease: "power2.out" }, "-=1.5");
    homeStratup.to(sc_animation5, { opacity: 1, y: 0, duration: 1, ease: "power2.out" }, "-=1");
    homeStratup.to(sc_animation6, { opacity: 1, y: 0, duration: 1, ease: "power2.out" }, "-=1.5");
    sc_animation1.forEach((headingAnimationLine) => {
        const tl = gsap.timeline({
            scrollTrigger: {
                trigger: headingAnimationLine,
                start: "top 90%",
                end: "bottom 60%",
                scrub: false,
                markers: false,
                toggleActions: "play none none none",
            },
        });

        const headingSplitLine = new SplitText(headingAnimationLine, { type: "words" });
        gsap.set(headingAnimationLine, { perspective: 400 });
        headingSplitLine.split({ type: "words" });
        tl.from(headingSplitLine.words, {
            duration: 1,
            delay: 0.3,
            opacity: 0,
            rotationX: -50,
            force3D: true,
            transformOrigin: "top center -50",
            stagger: 0.1,
        });
    });

    // Section Title Animation
    let splitTitleLines = gsap.utils.toArray(".sec-animation");
    splitTitleLines.forEach((splitTextLine) => {
        const tl = gsap.timeline({
            scrollTrigger: {
                trigger: splitTextLine,
                start: "top 90%",
                end: "bottom 60%",
                scrub: false,
                markers: false,
                toggleActions: "play none none none",
            },
        });

        const itemSplitted = new SplitText(splitTextLine, { type: "words, lines" });
        gsap.set(splitTextLine, { perspective: 400 });
        itemSplitted.split({ type: "lines" });
        tl.from(itemSplitted.lines, {
            duration: 1,
            delay: 0.3,
            opacity: 0,
            rotationX: -80,
            force3D: true,
            transformOrigin: "top center -50",
            stagger: 0.1,
        });
    });

    // 25. Title Animation
    let splitListLines = gsap.utils.toArray(".listing-animation");
    splitListLines.forEach((splitTextLine) => {
        const tl = gsap.timeline({
            scrollTrigger: {
                trigger: splitTextLine,
                start: "top 90%",
                end: "bottom 60%",
                scrub: false,
                markers: false,
                toggleActions: "play none none none",
            },
        });

        const itemSplitted = new SplitText(splitTextLine, { type: "words, lines" });
        gsap.set(splitTextLine, { perspective: 400 });
        itemSplitted.split({ type: "lines" });
        tl.from(itemSplitted.lines, {
            duration: 1,
            delay: 0.3,
            opacity: 0,
            rotationX: -80,
            force3D: true,
            transformOrigin: "top center -50",
            stagger: 0.1,
        });
    });

	
	document.onreadystatechange = function() {
		if (document.readyState === "complete") {
			$("#panel_left").addClass("panel_left");
			$("#panel_right").addClass("panel_right");
			$("#loader").addClass("loaded-circle");
			$("#loader-img").addClass("loaded-img");
			$("#preloader").addClass("loaded-img");
		}
	}

	    /*------------------------------------------
        = HIDE PRELOADER
    -------------------------------------------*/
  

	/*	=========================================================================
	When document is Scrollig, do
	========================================================================== */

	



	/* ==========================================================================
   When document is Scrollig, do
   ========================================================================== */
	
	$(window).on('scroll', function() {
		headerStyle();
	});

	
	
	/* ==========================================================================
   When document is loaded, do
   ========================================================================== */
	
	$(window).on('load', function() {
		handlePreloader();
	});

	

})(window.jQuery);
