(function ($) {
	"use strict";
	var windowOn = $(window);
  
	// Email validation
	function isValidEmail(email) {
	  // Simple email validation using a regular expression
	  const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
	  return emailRegex.test(email);
	}
  
	const btn = document.getElementById("button");
  
	document.getElementById("newsletter-map").addEventListener("submit", function (event) {
	  event.preventDefault();
  
	  const email = document.querySelector("#email").value;
  
	  // Validate email before sending
	  if (!isValidEmail(email)) {
		// Display an error message or perform any desired action for invalid email
		swal('Error', 'Please enter a valid email address', 'error');
		return;
	  }
  
	  const serviceID = "service_oq6bo4n";
	  const templateID = "template_rj8odm3";
  
	  // Show success message only after sending email
	  emailjs.sendForm(serviceID, templateID, this).then(
		() => {
		  swal(
			'Success! Your mail has been sent',
			'You clicked the <b style="color:green;">Submit</b> button!',
			'success'
		  );
  
		  // Clear form fields after successful submission
		  document.querySelector("#email").value = "";
		},
		(err) => {
		  alert(JSON.stringify(err));
		}
	  );
	});
  })(jQuery);
  